/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.fluid_generators.IFluidGenerator;
import com.ordana.immersive_weathering.data.position_tests.IPositionRuleTest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3825;
import net.minecraft.class_6880;

public class OtherFluidGenerator
implements IFluidGenerator {
    public static final Codec<OtherFluidGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_11154.method_39673().fieldOf("fluid").forGetter(OtherFluidGenerator::getFluid), (App)IFluidGenerator.FluidType.CODEC.optionalFieldOf("fluid_type", (Object)IFluidGenerator.FluidType.BOTH).forGetter(OtherFluidGenerator::getFluidType), (App)class_2680.field_24734.fieldOf("generate").forGetter(OtherFluidGenerator::getGrowth), (App)class_3825.field_25012.fieldOf("target").forGetter(OtherFluidGenerator::getTarget), (App)IPositionRuleTest.CODEC.optionalFieldOf("additional_target_check").forGetter(OtherFluidGenerator::getExtraCheck), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(OtherFluidGenerator::getPriority)).apply((Applicative)instance, OtherFluidGenerator::new));
    public static final IFluidGenerator.Type<OtherFluidGenerator> TYPE = new IFluidGenerator.Type<OtherFluidGenerator>(CODEC, "target_other");
    private final class_3611 fluid;
    private final IFluidGenerator.FluidType fluidType;
    private final class_2680 growth;
    private final class_3825 target;
    private final Optional<IPositionRuleTest> extraCheck;
    private final int priority;

    public OtherFluidGenerator(class_3611 fluid, IFluidGenerator.FluidType fluidType, class_2680 growth, class_3825 target, Optional<IPositionRuleTest> positionRuleTests, int priority) {
        this.fluid = fluid;
        this.fluidType = fluidType;
        this.growth = growth;
        this.target = target;
        this.extraCheck = positionRuleTests;
        this.priority = priority;
    }

    @Override
    public IFluidGenerator.FluidType getFluidType() {
        return this.fluidType;
    }

    @Override
    public IFluidGenerator.Type<?> getType() {
        return TYPE;
    }

    @Override
    public class_3611 getFluid() {
        return this.fluid;
    }

    public class_3825 getTarget() {
        return this.target;
    }

    public class_2680 getGrowth() {
        return this.growth;
    }

    public Optional<IPositionRuleTest> getExtraCheck() {
        return this.extraCheck;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Optional<class_2338> tryGenerating(List<class_2350> possibleFlowDir, class_2338 pos, class_1937 level, Map<class_2350, class_2680> neighborCache) {
        Supplier b = Suppliers.memoize(() -> level.method_23753(pos));
        for (class_2350 d : possibleFlowDir) {
            class_2338 p;
            class_2680 state = neighborCache.computeIfAbsent(d, arg_0 -> OtherFluidGenerator.lambda$tryGenerating$2(level, p = pos.method_10093(d), arg_0));
            if (!this.target.method_16768(state, level.field_9229) || this.extraCheck.isPresent() && !this.extraCheck.get().test((java.util.function.Supplier<class_6880<class_1959>>)b, p, level)) continue;
            level.method_8501(p, this.growth);
            return Optional.of(p);
        }
        return Optional.empty();
    }

    private static /* synthetic */ class_2680 lambda$tryGenerating$2(class_1937 level, class_2338 p, class_2350 c) {
        return level.method_8320(p);
    }
}

